package fm.qingting.demo;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import fm.qingting.qtsdk.QTException;
import fm.qingting.qtsdk.QTSDK;
import fm.qingting.qtsdk.callbacks.QTCallback;
import fm.qingting.qtsdk.api.QTUserCenter;
import fm.qingting.qtsdk.callbacks.QTAuthCallBack;
import fm.qingting.qtsdk.entity.UserInfo;
import fm.qingting.qtsdk.entity.UserToken;


/**
 * Created by lee on 2018/1/23.
 */

public class AuthActivity extends AppCompatActivity implements View.OnClickListener {

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_auth);
        findViewById(R.id.bt_web_auth).setOnClickListener(this);
        findViewById(R.id.bt_native_auth).setOnClickListener(this);
        findViewById(R.id.bt_native_thirdpart).setOnClickListener(this);
        findViewById(R.id.bt_user).setOnClickListener(this);
        findViewById(R.id.bt_logout).setOnClickListener(this);
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.bt_web_auth:
                //启动web授权
                QTSDK.startWebAuthorize(this, new QTAuthCallBack() {
                    @Override
                    public void onComplete(UserToken response) {
                        //授权成功
                        Toast.makeText(getBaseContext(), "成功", Toast.LENGTH_SHORT).show();

                    }

                    @Override
                    public void onException(QTException e) {
                        //授权异常，具体查看异常code
                        Toast.makeText(getBaseContext(), "失败", Toast.LENGTH_SHORT).show();
                    }

                    @Override
                    public void onCancel() {
                        //用户取消授权
                        Toast.makeText(getBaseContext(), "取消授权", Toast.LENGTH_SHORT).show();
                    }
                });

                break;
            case R.id.bt_native_auth:
                //先尝试启动蜻蜓app，如果失败则自动启动web授权
                QTSDK.startAuthorize(this, new QTAuthCallBack() {
                    @Override
                    public void onComplete(UserToken response) {
                        //授权成功
                        Toast.makeText(getBaseContext(), "成功", Toast.LENGTH_SHORT).show();
                    }

                    @Override
                    public void onException(QTException e) {
                        //授权异常，具体查看异常code
                        Toast.makeText(getBaseContext(), "失败", Toast.LENGTH_SHORT).show();
                    }

                    @Override
                    public void onCancel() {
                        //用户取消授权
                        Toast.makeText(getBaseContext(), "取消授权", Toast.LENGTH_SHORT).show();
                    }
                });
                break;
            case R.id.bt_native_thirdpart:
                //第三方登录例子，实际使用需要更换成调用方从API、获取的用户信息
                UserToken token = new UserToken();
                token.setAccessToken("test1111111111111111111111111111");
                token.setUserId("582977a4b7bb51a84be7098df8dbc946");
                token.setExpiresIn(100000000);
                QTSDK.thirdPartLogin(token, new QTAuthCallBack() {
                    @Override
                    public void onComplete(UserToken response) {
                        //授权成功
                        Toast.makeText(getBaseContext(), "成功", Toast.LENGTH_SHORT).show();
                    }

                    @Override
                    public void onException(QTException e) {
                        //授权异常，具体查看异常code
                        Toast.makeText(getBaseContext(), "失败", Toast.LENGTH_SHORT).show();
                    }

                    @Override
                    public void onCancel() {
                        //用户取消授权
                        Toast.makeText(getBaseContext(), "取消授权", Toast.LENGTH_SHORT).show();
                    }
                });
                break;
            case R.id.bt_user:
                QTUserCenter.getUserInfo(new QTCallback<UserInfo>() {
                    @Override
                    public void done(UserInfo result, QTException e) {
                        if (result != null && e == null) {
                            ((TextView) findViewById(R.id.tv_user)).setText(result.getNickname());
                            startActivity(new Intent(AuthActivity.this,UserInfoActivity.class));
                        } else {
                            ((TextView) findViewById(R.id.tv_user)).setText("未登陆");
                        }
                    }
                });
                break;
            case R.id.bt_logout:
                QTSDK.clear();
                break;
        }


    }
}
